
/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/*
 *  Real Time Counter (RTC) Test
 *
 */
#include "stdio.h"
#include "rtc.h"
#include "DM388_types.h"
#include "DM388_EVM.h"


UINT8 RTC_setreg(UINT32 regnum, UINT8 regval)
{
    while((RTC_STATUS & 0x01) != 0);  // Wait for not busy
    regnum = regval;
	return 0;
}

UINT8 RTC_getreg(UINT32 regnum, UINT8 *regval)
{
    while((RTC_STATUS & 0x01) != 0);  // Wait for not busy
     DM388_wait( 500 );
	*regval = regnum;
	return 0;
}

UINT16 RTC_cal_wait()
{
	UINT8 regval;
    RTC_getreg(RTC_CTRL, &regval);
	while((regval & 0x80) != 0)
	    RTC_getreg(RTC_SEC, &regval);
	return 0;
}
/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  rtc_test( )                                                             *
 *      Setting and retrieving values from RTC                              *
 *                                                                          *
 * ------------------------------------------------------------------------ */
INT16 rtc_test( )
{
	UINT8 regval;
	UINT8 hour = 0x12;
	UINT8 min  = 0x15;
	UINT8 sec  = 0x05;
	RTC_setreg(RTC_CTRL, 0x00);  // Stop RTC
	
	/* Set initial time */
	RTC_setreg(RTC_SEC,  sec );
	RTC_setreg(RTC_MIN,  min );
    RTC_setreg(RTC_HOUR, hour);

	platform_write("\nThe initialized time is: %02x:%02x:%02x\n", hour, min, sec);

	RTC_cal_wait();                 // Wait for calender not to be busy

	RTC_setreg(RTC_CTRL, 0x01);  // Start calender
    DM388_wait( 2000000 );

    /* Get current time */
    RTC_getreg(RTC_SEC, &regval);
	sec = regval;
    RTC_getreg(RTC_MIN, &regval);
	min = regval;
    RTC_getreg(RTC_HOUR, &regval);
	hour = regval;
    platform_write("The time now is:         %02x:%02x:%02x\n", hour, min, sec);
    if(sec != 5)    // Check if initialized value changed
        return 0;
	else
	{
	    platform_write("RTC did not start\n");
		return 1;
	}
}

